// By EVOLVED
// www.evolved-software.com

#define LensFlare 1

//--------------
// tweaks
//--------------  
   float2 ViewSize;
   float Offset=4;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
	Texture=<RenderTexture>;
     	ADDRESSU=Clamp;
        ADDRESSV=Clamp;
      };
   texture BloomTexture <string Name = " ";>;
   sampler BloomSampler=sampler_state 
      {
	Texture=<BloomTexture>;
     	ADDRESSU=Clamp;
        ADDRESSV=Clamp;
      };
   texture LensDirtTexture <string Name=" ";>;
   sampler LensDirtSampler=sampler_state 
      {
	Texture=<LensDirtTexture>;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
	float2 Tex:TEXCOORD0;
	float4 Tex1:TEXCOORD1;
	float4 Tex2:TEXCOORD2;
	float4 Tex3:TEXCOORD3;
	float4 Tex4:TEXCOORD4;
	float4 Tex5:TEXCOORD5;
	float4 Tex6:TEXCOORD6;
	float4 Tex7:TEXCOORD7;
	float4 Tex8:COLOR0;
	float4 Tex9:COLOR1;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos; 
 	OUT.Tex=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize;
 	OUT.Tex1.xy=OUT.Tex+float2(ViewSize.x,ViewSize.y)*Offset;
 	OUT.Tex1.zw=OUT.Tex+float2(0.0,ViewSize.y)*Offset;
 	OUT.Tex2.xy=OUT.Tex+float2(-ViewSize.x,ViewSize.y)*Offset;
 	OUT.Tex2.zw=OUT.Tex+float2(ViewSize.x,0.0)*Offset;
 	OUT.Tex3.xy=OUT.Tex+float2(-ViewSize.x,0.0)*Offset;
 	OUT.Tex3.zw=OUT.Tex+float2(ViewSize.x,-ViewSize.y)*Offset;
 	OUT.Tex4.xy=OUT.Tex+float2(0.0,-ViewSize.y)*Offset;
 	OUT.Tex4.zw=OUT.Tex+float2(-ViewSize.x,-ViewSize.y)*Offset;
	OUT.Tex5=float4((OUT.Tex-float2(0.1375,0.0))*float2(1.4,1.0),0.0,0.0);
	OUT.Tex9=float4(1-OUT.Tex,0.0,0.0);
 	OUT.Tex6=(OUT.Tex9*1.5)-0.25;
 	OUT.Tex7=(OUT.Tex9*1.55)-0.275;
 	OUT.Tex8=(OUT.Tex9*1.6)-0.3;
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
	float3 FrameRender=tex2Dlod(BloomSampler,IN.Tex.xyxy).xyz*0.25
	                  +tex2Dlod(BloomSampler,IN.Tex1.xyyy).xyz*0.0625
			  +tex2Dlod(BloomSampler,IN.Tex1.zwww).xyz*0.125
		          +tex2Dlod(BloomSampler,IN.Tex2.xyyy).xyz*0.0625
			  +tex2Dlod(BloomSampler,IN.Tex2.zwww).xyz*0.125
			  +tex2Dlod(BloomSampler,IN.Tex3.xyyy).xyz*0.125
		          +tex2Dlod(BloomSampler,IN.Tex3.zwww).xyz*0.0625
			  +tex2Dlod(BloomSampler,IN.Tex4.xyyy).xyz*0.125
			  +tex2Dlod(BloomSampler,IN.Tex4.zwww).xyz*0.0625;
 	float3 LensFlares=0.0;
	#if LensFlare == 1
	 float4 LensDirt=tex2Dlod(LensDirtSampler,IN.Tex.xyyy);
	 LensFlares.x=tex2Dlod(RenderSampler,0.3+IN.Tex.xyyy/2.5).x
	    	    +(tex2Dlod(RenderSampler,IN.Tex6).x*(1-saturate(dot(IN.Tex6-0.5,IN.Tex6-0.5)*8)))
	            +tex2Dlod(RenderSampler,0.1+IN.Tex9/1.25).x+tex2Dlod(RenderSampler,0.3+IN.Tex9/2.5).x;
	 LensFlares.y=tex2Dlod(RenderSampler,0.307+IN.Tex.xyyy/2.6).y
		    +(tex2Dlod(RenderSampler,IN.Tex7).x*(1-saturate(dot(IN.Tex7-0.5,IN.Tex7-0.5)*8)))
		    +tex2Dlod(RenderSampler,0.115+IN.Tex9/1.3).y+tex2Dlod(RenderSampler,0.307+IN.Tex9/2.6).y;
	 LensFlares.z=tex2Dlod(RenderSampler,0.314+IN.Tex.xyyy/2.7).z
		    +(tex2Dlod(RenderSampler,IN.Tex8).x*(1-saturate(dot(IN.Tex8-0.5,IN.Tex8-0.5)*8)))
		    +tex2Dlod(RenderSampler,0.129+IN.Tex9/1.35).z+tex2Dlod(RenderSampler,0.314+IN.Tex9/2.7).z;
	 LensFlares *=LensDirt.xyz;
	 float4 HaloVec=float4(normalize(0.5-IN.Tex5.xy)*0.5,0.0,0.0);
	 LensFlares.x +=tex2Dlod(RenderSampler,IN.Tex5+(HaloVec/1.01)).x*LensDirt.w;
	 LensFlares.y +=tex2Dlod(RenderSampler,IN.Tex5+HaloVec).y*LensDirt.w;
	 LensFlares.z +=tex2Dlod(RenderSampler,IN.Tex5+(HaloVec*1.01)).z*LensDirt.w;
	#endif
	return float4(FrameRender+LensFlares*0.01,0.0);
     }

//--------------
// techniques   
//--------------
    technique Bloom
      {
 	pass p1
      {	
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
